#include "stdafx.h"
#include "../../snap/ncp.h"


#define SW  0
#define CLIQUES 1


#define RETIG 0
#define RET 1
#define RETMULTI 2
#define RETWE 3


using namespace std;


PUNGraph GenMyCliques(const int& Nodes, const int& CliqueSize, const double& Alpha, TRnd& Rnd=TInt::Rnd);

PUNGraph StartInfection(PUNGraph Graph, const int& Size = 1);
PUNGraph EdgeInfectionStep(PUNGraph Graph, PUNGraph Casc, const double& Alpha, const double& Beta);
PUNGraph AddInducedEdges(const PUNGraph& G, const PUNGraph& Casc);
PUNGraph EdgeInfectionWithExplorationStep(PUNGraph G, PUNGraph Casc, const double& Alpha, const double& Beta, const double& Gamma);

void ProduceNCP(PUNGraph InfCasc, TStr OutFNm, TStr Desc);





int main(int argc, char* argv[]) {


  int NumberOfGraphs = 1;
  int NumberOfTrials = 1;

  int Population = 1000000;  //number of nodes
  int BeginWritePopulation = 5000;  //how often to output contagion
  int Degree = 100;  //average degree when applicable
  double Rewire = .1;
  int BeginMultiInfectionNumber = 100;
  double CascParamOne = .7;  //first contangtion parameter
  double CascParamTwo = .01;
  double CascParamThree = .001;

  int Extra = 5; //number of rounds past saturation to run
  double Saturation = .80; //
  int MaxNCP = 200000;
  bool SaveGraphs = false;

 
  TStr FileName; 
  TStr DataFileName;
  TStr Desc;
  TStr GraphName;
  TStr GraphDesc;
  TStr CascName;

  for(int GraphType = 0; GraphType <2 ; GraphType++){
  for(int GraphCount = 0; GraphCount < NumberOfGraphs; GraphCount++){  

    printf("running graph %d \n", GraphCount);
	PUNGraph Graph;	
    switch(GraphType){
	  case SW:
        Graph = TSnap::GenSmallWorld(Population, Degree/2, Rewire); 
		GraphName = "WS";	
		GraphDesc = "beta = " + TStr(Rewire);
		break;  
	  case CLIQUES:
		Graph = GenMyCliques(Population, Degree, Rewire);
		GraphName = "Clique";
		GraphDesc = "beta = " + TStr(Rewire);
		break;
	}

   
	char buffer [250];
	sprintf (buffer, "Graph-%d-%d", GraphType, GraphCount);
	FileName = TStr(buffer);
	sprintf (buffer, "Type: %s Pop = %d Deg = %d %s", GraphName.CStr(), Population, Degree, Desc.CStr());
	Desc = TStr(buffer);

	//use this to save graph and/or make ncpplot
	if(Population <= MaxNCP){
		ProduceNCP(Graph, "ncp." + FileName, Desc);
	}
	if(SaveGraphs){
	  TSnap::SaveEdgeList(Graph, FileName, Desc);
	}
	TSnap::PlotInDegDistr(Graph, "deg." + FileName, Desc, false, true);


	for(int CascadeType = 0; CascadeType < 4; CascadeType++){  	
	  switch(CascadeType){
	    case RETIG:
			CascName = "RETIG";
			break;
		case RET:
			CascName = "RET";
			break;
		case RETWE:
			CascName = "RETWE";
			break;
		case RETMULTI:
			CascName = "RETMULTI";
			break;
	  }
    for(int TrialCount = 0; TrialCount < NumberOfTrials; TrialCount++){  


	  int NextWritePopulation = BeginWritePopulation;  //minimum contagion size to write out.
	  printf("running graphtype %d, graph %d, cascadetype %d, trial %d \n", GraphType, GraphCount, CascadeType, TrialCount);

	 
	  //to store certain data from file for immediate graphs
	  TIntFltKdV NodesAndDensity;
	  TIntFltKdV NodesAndDiameter;
	  TIntFltKdV NodesAndEffDiameter;
	  
      //spread virus
	  PUNGraph Casc;
	  switch(CascadeType){
	    case RETIG:
		case RET:
		case RETWE:
			Casc = StartInfection(Graph);
			break;
		case RETMULTI:
			Casc = StartInfection(Graph, BeginMultiInfectionNumber);
			break;
	  }

	  int ExtraCount = 0;
	  int Round = 0;
	  int Diameter = 0;
	  double EffectiveDiameter = 0;
	  int MaxExpectedPopulation = int(Saturation * Population);  //we don't expect to see all points included for a long time.

	  while(1){  //exits when extra == EXTRA
		printf(".");
		//printf("CascPopulation = %d, ExtraCn = %d, NextWritePopExtra Count %d \r\n", Casc->GetNodes(), ExtraCount,  NextWritePopulation);



		TIntFltKdV AnfV;
		TSnap::GetAnf(Casc, AnfV, -1, false, 32); //-1 = no Max Distance, false = undirected, 32 = approximation parameter
		Diameter = AnfV.Last().Key;
		EffectiveDiameter = TAnf::CalcEffDiam(AnfV, 0.9);
		
		NodesAndDensity.Add(TIntFltKd(Casc->GetNodes(), float(Casc->GetEdges()/Casc->GetNodes()))); 
		NodesAndDiameter.Add(TIntFltKd(Casc->GetNodes(), float(Diameter)));
		NodesAndEffDiameter.Add(TIntFltKd(Casc->GetNodes(), float(EffectiveDiameter)));

		if(ExtraCount > Extra){ break; }

		//take next step
		switch(CascadeType){
	      case RETIG:
            Casc = AddInducedEdges(Graph, EdgeInfectionStep(Graph, Casc, CascParamOne, CascParamTwo));
		  break;
		  case RET:
		  case RETMULTI:
			Casc = EdgeInfectionStep(Graph, Casc, CascParamOne, CascParamTwo);
			break;
		  case RETWE:
			Casc = EdgeInfectionWithExplorationStep(Graph, Casc, CascParamOne, CascParamTwo, CascParamThree);
			break;
		}
	    //possibly write out contagion graph and update next time to do so
	    if(Casc->GetNodes() >= NextWritePopulation){
		  if((ExtraCount == 0) || (ExtraCount == Extra)){
	        //write to file
			if(!ExtraCount){
		      sprintf (buffer, "Graph-%d-%d-%d-%d-%d", GraphType, GraphCount, CascadeType, TrialCount, NextWritePopulation);
			} else {
			   sprintf (buffer, "Graph-%d-%d-%d-%d-%d+%d", GraphType, GraphCount, CascadeType, TrialCount, NextWritePopulation, ExtraCount);
			}
		    FileName = TStr(buffer);
			sprintf (buffer, "Type: %s " , GraphName.CStr());
			Desc = TStr(buffer);
			sprintf (buffer, "Pop = %d " , Population);
			Desc = Desc + TStr(buffer);
			sprintf (buffer, "Deg = %d " , Degree);
		    Desc = Desc + TStr(buffer);
			sprintf (buffer, "%s, " , GraphDesc.CStr());
			Desc = Desc + TStr(buffer);
			sprintf (buffer, "%s:" , CascName.CStr());
			Desc = Desc + TStr(buffer);
			sprintf (buffer, "CascParamOne = %f" , CascParamOne);
			Desc = Desc + TStr(buffer);
			sprintf (buffer, "CascParamTwo =  %f" , CascParamTwo); 
			Desc = Desc + TStr(buffer);



			if(SaveGraphs){
		        TSnap::SaveEdgeList(Casc, FileName, Desc);
			}
			if(NextWritePopulation < MaxNCP){
			   ProduceNCP(Casc, FileName, Desc);
			}
			TSnap::PlotInDegDistr(Casc, "deg." + FileName, Desc, false, true);
		  }
		  printf("C7");
		  if(NextWritePopulation == MaxExpectedPopulation){
		    ExtraCount++;
		  }  else {
		    while(Casc->GetNodes() >= NextWritePopulation){
			   NextWritePopulation = NextWritePopulation * 2;
		    }
		    if (NextWritePopulation > MaxExpectedPopulation) {
			  NextWritePopulation = MaxExpectedPopulation;
		    }
		  } // else 
		  printf("C8");
		} // if past WritePopulationMark
		Round++;
	  }//while


      
	
	  //Process the density and diameter
	  sprintf (buffer, "avgdeg.GraphData-%d-%d-%d-%d.tab", GraphType, GraphCount, CascadeType, TrialCount);
	  DataFileName = TStr(buffer);
      sprintf (buffer, "avgdeg.GraphData-%d-%d-%d-%d.plt", GraphType, GraphCount, CascadeType, TrialCount);
      TStr PlotFileName = TStr(buffer);
  

       //make charts of information.
       TGnuPlot GnuPlot(DataFileName, PlotFileName, "Average Degrees", true);  //last entry is grid

  
       //Do scatter plot of Nodes and Edges/Nodes
       GnuPlot.AddPlot(NodesAndDensity, gpwLines, "Average Degree", "pt 20"); 
	   GnuPlot.SetXYLabel("Nodes", "Average degree");
       GnuPlot.SetScale(gpsAuto);
       GnuPlot.SavePng();
       GnuPlot.SaveEps(22);

       sprintf (buffer, "diam.GraphData-%d-%d-%d-%d.tab", GraphType, GraphCount, CascadeType, TrialCount);
       DataFileName = TStr(buffer);
       sprintf (buffer, "diam.GraphData-%d-%d-%d-%d.plt", GraphType, GraphCount, CascadeType, TrialCount);
       PlotFileName = TStr(buffer);
       TGnuPlot GnuPlot2(DataFileName, PlotFileName, "Diameter", false);  //last entry is grid
       GnuPlot2.AddPlot(NodesAndDiameter, gpwLines, "Diameter", "pt 20"); 
       GnuPlot2.AddPlot(NodesAndEffDiameter, gpwPoints, "90% Effective Diameter", "pt 20");
       GnuPlot2.SetXYLabel("Nodes", "Average degree coefficient");
       GnuPlot2.SetScale(gpsAuto);
       GnuPlot2.SavePng();
       GnuPlot2.SaveEps(22);

	   //fclose(DataFile);

    }//for Trial Count
    }//for Cascade Type
  }//for Graph Count  
  } //for Graph Type
  return 0;
}



//  This function modified from code in Snap Examples by Jure Leskovec
void ProduceNCP(PUNGraph InfCasc, TStr OutFNm, TStr Desc){

  TExeTm ExeTm;
  Try

  const int DrawWhisk = -1; // Draw largest D whiskers
  const bool DoWhisk = true;
  const bool DoRewire = false; 
  const bool SaveInfo = false;
  const int KMin =  10; //minimum K (volume)
  const int KMax = Mega(100); // maximum K (volume)
  const int Coverage = 10; //coverage (so that every node is covered C times)
  TLocClust::Verbose = true; // plot intermediate output
  if (OutFNm.Empty()) { OutFNm = TStr("nccplot"); }
  if (Desc.Empty()) { Desc = OutFNm; }
  if (DrawWhisk > 0) {
    printf("*** Drawing whiskers (must have GraphViz installed)\n");
    TLocClust::DrawWhiskers(InfCasc, OutFNm, DrawWhisk);
  }
  printf("*** Plotting network community profile (NCP)\n");
  TLocClust::PlotNCP(InfCasc, OutFNm, "Graph: -> "+OutFNm+" "+Desc,
    DoWhisk, DoRewire, KMin, KMax, Coverage, SaveInfo);
  Catch
  printf("\nrun time: %s (%s)\n", ExeTm.GetTmStr(), TSecTm::GetCurTm().GetTmStr().CStr());

}





PUNGraph GenMyCliques(const int& Nodes, const int& CliqueSize, const double& Alpha, TRnd& Rnd){

  PUNGraph GraphPt = PUNGraph::TObj::New();
  TUNGraph& Graph = *GraphPt;
  Graph.Reserve(Nodes, CliqueSize*Nodes);

  for (int n = 0; n < Nodes; n++) {
    Graph.AddNode(n);
	//printf("added node %d", n);
  }
  int clique = 0;
  while(clique * CliqueSize < Nodes){
	int limit = min((clique + 1) * CliqueSize, Nodes);
    for (int n1 = clique * CliqueSize; n1 +1 < limit; n1++) {
      for (int n2 = n1+1; n2 < limit; n2++) { 
	    if(Rnd.GetUniDev() < Alpha){
		 Graph.AddEdge(n1, Rnd.GetUniDevUInt(Nodes));  //could make sure edge not there already
	    } else {
		  Graph.AddEdge(n1, n2);
	    }
	  }
    }
	clique++;
  }
  Graph.Defrag();
  return GraphPt;
}



//takes induced subgraph of Graph with nodes of Casc
PUNGraph InducedSubgraph(const PUNGraph& G, const PUNGraph& Casc) {
  //TIntPrV EdgeV;
  PUNGraph Inducedgraph = TUNGraph::New(); 
  const int StartId = G->GetRndNId();
  TIntV CascNIdV;  
  Casc->GetNIdV(CascNIdV);
  //first add all nodes
  for (int n = 0; n < CascNIdV.Len(); n++) {
    const TUNGraph::TNodeI NI = G->GetNI(CascNIdV[n]);
	Inducedgraph->AddNode(NI.GetId());
  }
  //second add all edges
  for (int n = 0; n < CascNIdV.Len(); n++) {
    const TUNGraph::TNodeI NI = G->GetNI(CascNIdV[n]);
    for (int i = 0; i < NI.GetOutDeg(); i++) {
	  if (Casc->IsNode(NI.GetOutNId(i))){ //both nodes in graph
		if (!Casc->IsEdge(NI.GetId(), NI.GetOutNId(i))){ //egde not already included
		   Inducedgraph->AddEdge(NI.GetId(), NI.GetOutNId(i)); 
		}
	  }
    }
  }
  return Inducedgraph;
}

PUNGraph AddInducedEdges(const PUNGraph& G, const PUNGraph& Casc) {
 //TIntPrV EdgeV;
  TIntV CascNIdV;  
  Casc->GetNIdV(CascNIdV);
  //second add all edges
  for (int n = 0; n < CascNIdV.Len(); n++) {
    const TUNGraph::TNodeI NI = G->GetNI(CascNIdV[n]);
    for (int i = 0; i < NI.GetOutDeg(); i++) {
	  if (Casc->IsNode(NI.GetOutNId(i))){ //both nodes in graph
		if (!Casc->IsEdge(NI.GetId(), NI.GetOutNId(i))){ //egde not already included
		   Casc->AddEdge(NI.GetId(), NI.GetOutNId(i)); 
		}
	  }
    }
  }
  return Casc;
}


/*  StartInfectionStart takes in a graph, and outputs a graph with a random vertex of the input graph */
PUNGraph StartInfection(PUNGraph Graph, const int& Size){
  PUNGraph Casc = TUNGraph::New();
  for (int i = 0; i < Size; i++){
	int StartId = Graph->GetRndNId();
    Casc->AddNode(StartId);
  }
  return Casc;
}


/*  EdgeInfectionStep takes in a graph, a cascade graph, and two parameters Alpha and Beta
    It then addes each edge from the graph to the outside with probability Beta
	and addes each internal edge with probability ~2 Alpha */
PUNGraph EdgeInfectionStep(PUNGraph Graph, PUNGraph Casc, const double& Alpha, const double& Beta) {
  TIntV CascNIdV;  
  Casc->GetNIdV(CascNIdV);
  for (int n = 0; n < CascNIdV.Len(); n++) {
    const TUNGraph::TNodeI NI = Graph->GetNI(CascNIdV[n]);
    for (int i = 0; i < NI.GetOutDeg(); i++) {
      if (Casc->IsEdge(NI.GetId(), NI.GetOutNId(i))) { continue; } //egde already included
	  if (Casc->IsNode(NI.GetOutNId(i))){ //both nodes in graph
	    if (TInt::Rnd.GetUniDev() < Alpha){
		  Casc->AddEdge(NI.GetId(), NI.GetOutNId(i));
		}
	  } 
	  else if (TInt::Rnd.GetUniDev() < Beta) {	      
	    Casc->AddNode(NI.GetOutNId(i));
	    Casc->AddEdge(NI.GetId(), NI.GetOutNId(i));   
	  }
	}//for
  }//for
  return Casc;
}

PUNGraph EdgeInfectionWithExplorationStep(PUNGraph G, PUNGraph Casc, const double& Alpha, const double& Beta, const double& Gamma) {
    TIntV CascNIdV;  
	Casc->GetNIdV(CascNIdV);
    for (int n = 0; n < CascNIdV.Len(); n++) { //cycle through nodes in cascade
      const TUNGraph::TNodeI NI = G->GetNI(CascNIdV[n]);
      for (int i = 0; i < NI.GetOutDeg(); i++) {  //cycle through neighbors
        if (Casc->IsEdge(NI.GetId(), NI.GetOutNId(i))) { //egde already included
		  const TUNGraph::TNodeI NJ = Casc->GetNI(NI.GetOutNId(i));  
		  for (int j = 0; j < NJ.GetOutDeg(); j++) {  //cycle through neigbhbors edges
			if (!Casc->IsEdge(NJ.GetOutNId(j), NI.GetId())) { //egde already included in casc */
			  if (TInt::Rnd.GetUniDev() < Gamma){  //include with probability gamma
				Casc->AddEdge(NJ.GetOutNId(j), NI.GetId());
			  }//if Rnd
		    }//if closure edge not already included
		  }//for out degree 
		}//if edge already included
		if (Casc->IsNode(NI.GetOutNId(i))){ //both nodes in graph
		  if (TInt::Rnd.GetUniDev() < Alpha){ 
		     Casc->AddEdge(NI.GetId(), NI.GetOutNId(i));
		  }
		} 
		else if (TInt::Rnd.GetUniDev() < Beta) {	      
		  Casc->AddNode(NI.GetOutNId(i));
		  Casc->AddEdge(NI.GetId(), NI.GetOutNId(i)); 
        }
      }
	}
    return Casc;
}
